<?php
/*
Plugin Name: Keni8 PR Setting
Plugin URI: https://blog.gti.jp/download/keni8-pr-setting-plugin/
Description: 記事の最初にPR文を表示するプラグイン
Version: 0.1
Author: Takeshi Satoh@GTI Inc.
Author URI: https://gti.co.jp/
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: keni8-pr-setting
Domain Path: /languages
*/

// プラグインの処理を書く

require_once(plugin_dir_path(__FILE__) . 'admin/settings.php');



// 全体設定の値、または個別設定の値を取得して最初のH2の前に出力
function keni8_pr_text($keni_time_disp)
{
    global $post;
    if (! is_singular()) {
        return $keni_time_disp;
    }
    $options = get_option('keni8_pr_setting', false);
    $text = '';
    $enable = 0;
    if (is_array($options)) {
        $text = $options['text'];
        $enable = $options['enable'];
    }

    $post_meta = get_post_meta($post->ID, 'keni8_pr_setting', "");
    if (is_array($post_meta)) {
        if (isset($post_meta[0]['enable'])) {
            $post_meta = $post_meta[0];
        }
    }

    $post_meta_text = $post_meta['text'] ?? '';
    $post_meta_enable = $post_meta['enable'] ?? 0;
    $pr_html = '';
    // 両方とも有効
    if ($enable == 1 && $post_meta_enable == 1) {
        $pr_html = $post_meta_text;
    } elseif ($enable == 1 && $post_meta_enable == 0) { // 全体設定のみ有効
        $pr_html = $text;
    } elseif ($enable == 0 && $post_meta_enable == 1) { // 個別設定のみ有効
        $pr_html = $post_meta_text;
    }
    // 両方とも無効の場合は何も出力しない
    if ($pr_html != '') {
        echo '<div class="keni8-pr">' . $pr_html . '</div>';
    }
    return $keni_time_disp;
}
// get_option('keni_time_disp') 取得時に表示
add_filter('option_keni_time_disp', 'keni8_pr_text', 10, 1);
