<?php

/**
 * @package Keni8 PR Setting
 */
/*
Plugin Name: Keni8 PR Setting
*/
// 設定画面構築
function keni8_pr_setting_menu()
{
    // 独立したメニューを追加
    add_menu_page(
        '賢威8 ステマ規制用テキスト',
        '賢威8 ステマ規制用テキスト',
        'manage_options',
        'keni8_pr_setting',
        'keni8_pr_setting_page'
    );
}
add_action('admin_menu', 'keni8_pr_setting_menu');

// 設定画面のHTML
function keni8_pr_setting_page()
{
    // nonceの設定
    wp_nonce_field('keni8_pr_setting', 'keni8_pr_setting_nonce');
    ?>
    <div class="wrap">
        <h2>賢威8 ステマ規制用テキスト Setting</h2>
        <form action="options.php" method="post">
            <?php
                // 設定項目を出力する
                settings_fields('keni8_pr_setting');
    do_settings_sections('keni8_pr_setting');
    ?>
            <p class="submit">
                <input type="submit" name="submit" id="submit" class="button button-primary" value="変更を保存">
            </p>
        </form>
    </div>
<?php
}

// 設定項目の登録と初期化
function keni8_pr_setting_init()
{
    register_setting(
        'keni8_pr_setting',
        'keni8_pr_setting',
        'keni8_pr_setting_validate'
    );
    register_setting(
        'keni8_pr_setting_enable',
        'keni8_pr_setting_enable'
    );
    add_settings_section(
        'keni8_pr_setting_section',
        'ステマ規制用テキスト',
        'keni8_pr_setting_section',
        'keni8_pr_setting'
    );
    add_settings_field(
        'keni8_pr_setting_text',
        'ステマ規制用テキスト',
        'keni8_pr_setting_text',
        'keni8_pr_setting',
        'keni8_pr_setting_section'
    );
}
add_action('admin_init', 'keni8_pr_setting_init');

function keni8_pr_setting_validate($input)
{
    $newinput = $input;
    $newinput['text'] = wp_kses_post($input['text']);
    return $newinput;
}

function keni8_pr_setting_section()
{
    ?>
    <p>文言を入力してください。</p>
<?php
}

function keni8_pr_setting()
{
    $options = get_option('keni8_pr_setting');
    $text = $options['text'];
    echo $text;
}

function keni8_pr_setting_enable()
{
    ?>
    <p>ステマ規制用テキストを表示するかどうかを選択してください。</p>
<?php
}

function keni8_pr_setting_text()
{
    $enable = 0;
    $text = '';
    $options = get_option('keni8_pr_setting', false);
    if (is_array($options)) {
        $enable = $options['enable'];
        $text = $options['text'];
    }
    ?>
    <label><input type="radio" name="keni8_pr_setting[enable]" value="1" <?php checked(1, $enable); ?>>有効</label>
    <label><input type="radio" name="keni8_pr_setting[enable]" value="0" <?php checked(0, $enable); ?>>無効</label>
    <!--テキストエリアを追加-->
    <textarea name="keni8_pr_setting[text]" id="keni8_pr_setting_enable_text" cols="30" rows="10" class="large-text"><?php echo esc_textarea($text); ?></textarea>
<?php
}

function keni8_pr_setting_enable_init()
{
    add_settings_section(
        'keni8_pr_setting_enable_section',
        'ステマ規制用テキストの表示',
        'keni8_pr_setting_enable',
        'keni8_pr_setting_enable'
    );
    add_settings_field(
        'keni8_pr_setting_enable_text',
        'ステマ規制用テキストの表示',
        'keni8_pr_setting_enable_text',
        'keni8_pr_setting_enable',
        'keni8_pr_setting_enable_section'
    );
}
add_action('admin_init', 'keni8_pr_setting_enable_init');

// 個別ページに個別設定の項目を追加
function keni8_pr_setting_add_meta_box()
{
    // 全体設定の無効フラグ追加。無効時には独自文言設定を追加。
    add_meta_box(
        'keni8_pr_setting_meta_box',
        'ステマ規制用テキスト',
        'keni8_pr_setting_meta_box',
        'post',
        'side'
    );
}

add_action('add_meta_boxes', 'keni8_pr_setting_add_meta_box');

// 個別記事での設定項目のHTML
function keni8_pr_setting_meta_box()
{
    // 個別記事の値を取得
    global $post;
    $post_meta = get_post_meta($post->ID, 'keni8_pr_setting', "");
    if (is_array($post_meta)) {
        if (isset($post_meta[0]['enable'])) {
            $post_meta = $post_meta[0];
        }
    }
    $post_meta_enable = $post_meta['enable'] ?? 0;
    $post_meta_text = $post_meta['text'] ?? '';
    ?>
    <h2>個別設定有効にするか（有効の場合のみ下記コンテンツを表示。）</h2>
    <label><input type="radio" name="keni8_pr_setting[enable]" value="0" <?php checked(0, $post_meta_enable); ?>>全体設定を適用する</label>
    <label><input type="radio" name="keni8_pr_setting[enable]" value="1" <?php checked(1, $post_meta_enable); ?>>個別設定を適用する</label>
    <h2>ステマ規制用テキストを入力してください。</h2>
        <p class="howto">この投稿だけ非表示にしたい場合は「個別設定を適用する」を適用した上でこちらを空欄にしてください</small>
        <textarea name=" keni8_pr_setting[text]" id="keni8_pr_setting_text" cols="30" rows="10" class="large-text"><?php echo esc_textarea($post_meta_text); ?></textarea>
    <?php
}

// 個別記事の保存処理
function keni8_pr_setting_save_postdata($post_id)
{
    // 自動保存時の処理を回避
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }
    // 権限のチェック
    if (!current_user_can('edit_post', $post_id)) {
        return $post_id;
    }
    // データの保存
    if (isset($_POST['keni8_pr_setting'])) {
        $newdata = $_POST['keni8_pr_setting'];
        $newdata['text'] = wp_kses_post($newdata['text']);
        update_post_meta($post_id, 'keni8_pr_setting', $newdata);
    }
}
add_action('save_post', 'keni8_pr_setting_save_postdata');

// アンインストール時に保存したデータを削除
function keni8_pr_setting_uninstall()
{
    delete_option('keni8_pr_setting');
    // 個別記事に保存したpost_meta「keni8_pr_setting」のデータを削除
    global $wpdb;
    $wpdb->query("DELETE FROM $wpdb->postmeta WHERE meta_key = 'keni8_pr_setting'");
}
register_uninstall_hook(__FILE__, 'keni8_pr_setting_uninstall');
