<?php
// Simple PO to MO converter
// Usage: php compile_mo.php <input.po> <output.mo>

if ($argc < 3) {
    die("Usage: php compile_mo.php <input.po> <output.mo>\n");
}

$input = $argv[1];
$output = $argv[2];

if (!file_exists($input)) {
    die("Input file not found.\n");
}

$po_content = file_get_contents($input);
$lines = explode("\n", $po_content);

$translations = [];
$current_msgid = '';
$current_msgstr = '';
$state = ''; // 'msgid', 'msgstr'

foreach ($lines as $line) {
    $line = trim($line);
    if (empty($line) || $line[0] === '#') continue;

    if (preg_match('/^msgid "(.*)"$/', $line, $matches)) {
        if ($state === 'msgstr' && $current_msgid !== '') {
            $translations[$current_msgid] = $current_msgstr;
            $current_msgid = '';
            $current_msgstr = '';
        }
        $state = 'msgid';
        $current_msgid = $matches[1];
    } elseif (preg_match('/^msgstr "(.*)"$/', $line, $matches)) {
        $state = 'msgstr';
        $current_msgstr = $matches[1];
    } elseif (preg_match('/^"(.*)"$/', $line, $matches)) {
        if ($state === 'msgid') {
            $current_msgid .= $matches[1];
        } elseif ($state === 'msgstr') {
            $current_msgstr .= $matches[1];
        }
    }
}
// Add last entry
if ($state === 'msgstr' && $current_msgid !== '') {
    $translations[$current_msgid] = $current_msgstr;
}

// Write MO file
$fp = fopen($output, 'wb');
if (!$fp) {
    die("Cannot open output file.\n");
}

// Magic number
fwrite($fp, pack('L', 0x950412de));
// Revision
fwrite($fp, pack('L', 0));
// Number of strings
fwrite($fp, pack('L', count($translations)));

// Offset of table with original strings
$offset_originals = 28; // Header size (7 * 4 bytes)
fwrite($fp, pack('L', $offset_originals));

// Offset of table with translation strings
$offset_translations = $offset_originals + (count($translations) * 8);
fwrite($fp, pack('L', $offset_translations));

// Size of hashing table (0 for now)
fwrite($fp, pack('L', 0));
// Offset of hashing table
fwrite($fp, pack('L', $offset_translations + (count($translations) * 8)));

// Generate string data
$originals_data = '';
$translations_data = '';
$originals_table = '';
$translations_table = '';

$start_offset = $offset_translations + (count($translations) * 8); // Start of string data
$current_offset = $start_offset;

// Sort by original string (msgid) for binary search if needed, but not strictly required for simple MO
ksort($translations);

foreach ($translations as $msgid => $msgstr) {
    // Original
    $len = strlen($msgid);
    $originals_table .= pack('L', $len);
    $originals_table .= pack('L', $current_offset);
    $originals_data .= $msgid . "\0";
    $current_offset += $len + 1;
}

foreach ($translations as $msgid => $msgstr) {
    // Translation
    $len = strlen($msgstr);
    $translations_table .= pack('L', $len);
    $translations_table .= pack('L', $current_offset);
    $translations_data .= $msgstr . "\0";
    $current_offset += $len + 1;
}

// Write tables
fseek($fp, $offset_originals);
fwrite($fp, $originals_table);
fseek($fp, $offset_translations);
fwrite($fp, $translations_table);

// Write string data
fseek($fp, $start_offset);
fwrite($fp, $originals_data . $translations_data);

fclose($fp);

echo "MO file compiled successfully.\n";
