# GTI 賢威-SYN 管理ツール

WordPress テーマ **「賢威8」** から **「SYN（SYNオウンド）」** への移行を支援するための管理ツールです。  
PV統合、TOC（目次）自動挿入、アイキャッチ表示移行など、移行時の作業を簡略化するための機能をまとめています。

---

## 🧰 主な機能

### ✅ PV統合ツール【v1.0.0】
- 賢威テーマで保持していた PV カウントデータを SYN に統合
- Dry-run（件数確認）＋バッチ処理による安全な移行

---

### ✅ SYN TOC（目次）自動挿入機能【v1.1.0】
- 記事本文に `[synx_toc]` が無い場合、自動的に TOC を生成
- 管理画面「賢威-SYNツール」配下に設定画面を用意
- 設定可能項目
  - TOC の自動表示 ON / OFF  
  - 挿入位置（タイトル直下 / 最初の H2 の前）  
  - 見出しレベル（H2〜H4）

---

### ✅ アイキャッチポリシー移行ツール（賢威 → SYN）【v1.2.0】
賢威8 と SYN ではアイキャッチ表示仕様が異なるため、  
過去記事のアイキャッチ表示状態を正しく移行するための一括変換ツールです。

#### ● 主な動作
- 賢威の **個別設定 `keni_thumbnail_disp_post`**  
- 賢威の **全体設定 `keni_thumbnail_disp`**  
を読み取り、SYN の `_synx_eyecatch` に変換  
（※ `_synx_eyecatch = 1` が「非表示」）

#### ● Dry-run（書き込みなし）
- 対象件数・更新件数・スキップ件数を表示  
- 記事ごとの変換結果を一覧表示  
- 投稿状態・日時・賢威設定（個別/全体）も確認可能  

#### ● 実行モード（書き込みあり）
- `_synx_eyecatch = 1` を安全にセット  
- すでに `_synx_eyecatch` が存在する記事はスキップ  

#### ● 変換ルール（抜粋）
| 賢威 全体 | 賢威 個別 | SYN 設定 |
|----------|-----------|-----------|
| 表示 | デフォルト / 表示 | そのまま（未設定） |
| 表示 | 非表示 | 非表示に変換（1） |
| 非表示 | デフォルト / 非表示 | 非表示に変換（1） |
| 非表示 | 表示 | そのまま（未設定） |

---

### ✅ 賢威ショートコード互換機能【v1.3.0】
賢威テーマで使用していたショートコードを SYN テーマでもそのまま利用可能にします。
- `[keni-linkcard]` を `[blogcard]` に自動変換
- `[cc id="123"]` 共通コンテンツショートコード対応
- functions.php との競合を完全回避
- 管理画面で機能の ON/OFF 切り替え可能
- 説明は https://blog.gti.jp/post-75068/ を参照してください
- この追加機能は上記リンク先で紹介したコードを基にしています
- この機能を有効にすると functions.php に同様のコードを追加する必要がなくなります
- 削除しなくても動作しますが、重複を避けるために **functions.php からは削除することを推奨します**

---

### ✅ 期間別ランキング機能【v1.4.0】
週間・月間・全期間のアクセスランキングを表示するウィジェットを追加します。
- **ウィジェット「【GTI】期間別ランキング」**
    - 集計期間（週間・月間・全期間）を選択可能
    - カテゴリー絞り込み（指定カテゴリー / 現在のカテゴリー）
    - 0 view の記事を除外するオプション
    - SYN OWND テーマのデザインを継承（リスト型、カード型など）
- **管理画面で ON/OFF 切り替え可能**
    - デフォルトは OFF です。「SYN期間別ランキング」メニューから有効化してください。
- **拡張性**
    - `gti_period_ranking_ranges` フックで任意の集計期間（例：6ヶ月）を追加可能
    ```php
    add_filter('gti_period_ranking_ranges', function ($ranges) {
        $ranges['6month'] = '6ヶ月';
        return $ranges;
    });
    ```
  - **注意**
    - ※独自実装のため、SYN OWND テーマのランキングウィジェットとは異なる表示となります

---

### ✅ 賢威ボックス互換レイヤー【v1.5.0】
賢威8 で使用されていたボックススタイル（`.box_style` 等）を、SYN OWND のデザインに合わせて装飾します。
- **既存記事の表示崩れを防止**
    - HTMLはそのままで、CSSのみを適用してデザインを整えます。
- **ブロックパターンの提供**
    - 「GTI 賢威→SYN 互換」カテゴリーに、ボックススタイルのブロックパターンを追加します。
- **CSSカスタマイズ**
    - 子テーマや親テーマに `gti-keni-tools/box-style-compat.css` を配置することで、プラグインのCSSを上書き可能です。
---

## 💡 インストール方法

### 方法1: WordPressアップロードインストール（推奨）

1. **ZIPファイルをダウンロード**
   - [GitHubリリースページ](https://github.com/taman777/gti-keni-tools/releases)から最新版のZIPファイルをダウンロード
   
2. **WordPressにアップロード**
   - WordPress 管理画面 → **プラグイン → 新規追加 → プラグインのアップロード**
   - ダウンロードした `gti-keni-tools.zip` を選択してアップロード
   - **今すぐインストール** をクリック
   
3. **有効化**
   - インストール完了後、**プラグインを有効化** をクリック
   
4. **設定**
   - メニュー **「賢威-SYNツール」** から各機能を利用できます

### 方法2: 手動インストール（開発者向け）

1. プラグインをダウンロードまたはクローン
   ```bash
   git clone https://github.com/taman777/gti-keni-tools.git
   ```

2. `/wp-content/plugins/gti-keni-tools/` にアップロード

3. 依存関係をインストール（GitHub自動更新機能を使用する場合）
   ```bash
   composer install --no-dev
   ```

4. WordPress 管理画面 → **プラグイン → 有効化**

### 方法3: ZIPパッケージのビルド（開発者向け）

開発環境でZIPパッケージを作成する場合：

```powershell
# PowerShellスクリプトを実行
powershell -ExecutionPolicy Bypass -File create-zip.ps1
```

これにより `gti-keni-tools.zip` が生成され、WordPressの管理画面からアップロードインストールできます。

---

## 🎯 使い方

メニュー **「賢威-SYNツール」** から各機能を利用できます：
- **PV統合** - 賢威のPVデータをSYNに統合
- **TOC設定** - 目次の自動挿入設定
- **アイキャッチ移行ツール** - Dry-run / 実行モード
- **ショートコード互換** - 賢威ショートコードの互換性（v1.3.0）
- **期間別ランキング** - ランキングウィジェットの有効化（v1.4.0）
- **賢威BOXスタイル** - ボックス互換レイヤーの有効化（v1.5.0）

---

## 🧩 開発構成
```text
gti-keni-tools/
├── gti-keni-tools.php                      # メインプラグインファイル
├── inc/
│   ├── keni-tools-core.php                 # 管理メニュー・モジュール基盤
│   └── tools/
│       ├── pv-merge.php                    # PV統合モジュール
│       ├── toc-manager.php                 # TOC自動挿入モジュール
│       ├── eyecatch-policy-migrator.php    # アイキャッチ移行ツール（v1.2.0）
│       ├── keni-shortcode-compat.php       # 賢威ショートコード互換（v1.3.0）
│       ├── period-ranking.php              # 期間別ランキング（v1.4.0）
│       └── keni-box-style-compat.php       # 賢威ボックス互換（v1.5.0）
└── vendor/
    └── yahnis-elsts/plugin-update-checker/ # GitHub自動更新
```

---

## 🪄 アップデート履歴（Changelog）

### **1.5.0（2025-12-07）**
**賢威ボックス互換レイヤーを追加**
- 賢威8時代のボックススタイル（.box_style 等）をSYN風に装飾
- ブロックパターン「GTI 賢威→SYN 互換」を追加
- CSS読み込みのテーマ上書き対応（子テーマ/親テーマでカスタマイズ可能）

### **1.4.0（2025-11-29）**
**期間別ランキング機能を追加**
- 週間・月間・全期間のランキングを表示するウィジェットを追加
- カテゴリー絞り込み、0 view 除外機能
- 管理画面で機能の有効化/無効化を設定可能
- SQL最適化による高速な集計処理
- `gti_period_ranking_ranges` フックで任意の集計期間（例：6ヶ月）を追加可能
- ※この機能は独自実装のため、SYN OWND テーマのランキングウィジェットとは異なる表示となります

### **1.3.0（2025-11-22）**
**賢威ショートコード互換機能を追加**
- `[keni-linkcard]` → `[blogcard]` 自動変換
- `[cc id="123"]` 共通コンテンツショートコード対応
- functions.php との競合を完全回避（独自関数名使用）
- 管理画面で ON/OFF 切り替え可能
- 賢威テーマのショートコードを SYN テーマでもシームレスに利用可能

### **1.2.0（2025-11-16）**
**賢威 → SYN のアイキャッチポリシー移行ツールを追加**
- 賢威の個別設定・全体設定を読み取り、SYN の `_synx_eyecatch` に変換  
- Dry-run で結果一覧を確認可能  
- 実行モードで `_synx_eyecatch = 1`（非表示）を安全にセット  
- `_synx_eyecatch` 設定済み記事はスキップ  
- 処理結果を管理画面の表形式で確認可能

### **1.1.0（2025-11-09）**
- SYN テーマ向け TOC（目次）自動挿入を新規追加  
- 管理メニュー「SYN目次設定」を追加

### **1.0.0（2025-10-31）**
- 初回リリース
- PV統合ツールを実装
- 管理メニュー「賢威-SYNツール」を追加

---

## 🧑‍💻 開発者

**株式会社ジーティーアイ (GTI)**  
Website: https://gti.co.jp/  
GitHub: https://github.com/taman777/gti-keni-tools

---

## 🪶 ライセンス

This plugin is released under the  
**GPLv2 or later**  
https://www.gnu.org/licenses/gpl-2.0.html

---

© 2025 GTI Inc. All rights reserved.
