# GTI IP Gate 完全ガイド

GTI IP Gate は、特定のディレクトリ全体を **IP制限 + パスワード認証** で二重に保護するための軽量ゲートウェイツールです。  
WordPress 等の重い CMS を使わず、シンプルなディレクトリや静的サイト、社内ツールを素早く保護したい場合に最適です。

---

## 0. 必要環境
- **PHP 8.0 以上**: `str_starts_with` 等の関数を使用しているため。
- **Apache (mod_rewrite 必須)**: `.htaccess` によるルーティングを行うため。

---

## 動作確認済み環境
- **エックスサーバー (XSERVER)**
- **ロリポップ！ (LOLIPOP)**
  - ※ サーバーパネル等で PHP 8.0 以上を選択して運用してください。

---

## 1. 構成と設置

### ディレクトリ構成
保護したいディレクトリ（例: `secret`）を作成し、その中に以下のファイルを配置します。

```text
/secret (このディレクトリを保護)
 ├─ .htaccess               # 全アクセスを PHP ゲートへ送る司令塔
 └─ /admin                  # 管理用ディレクトリ
     ├─ index.php           # アクセス判定を行う心臓部
     ├─ admin.php           # ブラウザ管理画面
     ├─ allow_ips_conf.cgi  # 許可IP（自動生成・Git除外推奨）
     └─ admin_conf.cgi      # 管理者認証（自動生成・Git除外推奨）
```

### 設置手順
1.  本リポジトリの `root_dir` 内のファイルを、**任意の名前（例: `secret`）にリネームして** サーバーにアップロードします。
2.  ブラウザで `https://あなたのドメイン/secret/admin.php` にアクセスします。
3.  **初期ID/パスワード** でログインします：
    - **ID**: `admin`
    - **パスワード**: `admin`
4.  ログイン後、画面下の設定アイコン（⚙️）から、**必ず自分専用の ID とパスワードに変更** してください。

---

## 2. 使い方

### 許可IPの追加
管理画面に「あなたの現在のIPアドレス」が表示されます。その横の「このIPを追加」ボタンを押すだけで、その場所からのアクセスが許可されます。

### 注意事項
- **パス制限**: 許可された IP であっても、ディレクトリのルート（`/secret/`）などは「Forbidden」となります。これはディレクトリ内の一覧を隠すための仕様です。**具体的なファイル名（例: `index.html` や `admin.php`）を指定してアクセス** してください。
- **共有環境**: 同じオフィスの Wi-Fi などを使っているメンバーは、同じ IP アドレスを共有しているため、一人が許可されると全員がアクセス可能になります。より厳格な管理が必要な場合は ID/パスワードによる保護を併用してください。

---

## 3. トラブルシューティング

### IPが変わっていないのにアクセスできない / 許可したのに見えない
- **キャッシュのクリア**: 強力なキャッシュ無効化設定を入れておりますが、ブラウザ側に古い情報が残っている場合があります。「シークレットモード」で試すか、ブラウザのキャッシュをクリアしてください。
- **プロキシ/CDN**: Cloudflare 等を利用している場合、判定される IP がプロキシサーバーのものになることがあります。管理画面に表示される「現在のIP」が、実際の自分のIP（確認サイト等で調べたもの）と一致しているか確認してください。

### デバッグモード
挙動がおかしい場合は、URLの末尾に `?debug=1` をつけてアクセスしてください。サーバーがどのようにパスや IP を解釈しているかが詳しく表示されます。
例: `https://example.com/secret/test.png?debug=1`

### 締め出された場合（緊急復旧）
管理画面に入れなくなった場合は、FTP 等で以下の操作を行ってください：
1.  `admin/admin_conf.cgi` を削除 → ID/パスワードが `admin/admin` にリセットされます。
2.  `admin/allow_ips_conf.cgi` に直接自分の IP を追記する。
3.  もしくは一時的に `.htaccess` をリネームして無効化する。

---

## 4. ライセンス
MIT License

---

## 作者
株式会社ジーティーアイ (GTI)  
[https://gti.co.jp](https://gti.co.jp)
