<?php
/**
 * Email Notification Logic
 */

function gti_forms_send_emails( $form_id, $data, $customer_email, $raw_data = array() ) {
	$form_title = get_the_title( $form_id );
	$site_name = get_bloginfo( 'name' );
	
	// Get per-form settings
	$admin_recipient = get_post_meta( $form_id, '_gti_admin_email', true );
	if ( ! $admin_recipient ) $admin_recipient = get_option( 'admin_email' );

	/**
	 * Filter admin recipient (To)
	 * Useful for routing inquiries to different departments based on field values
	 */
	$admin_recipient = apply_filters( 'gti_forms_admin_recipient', $admin_recipient, $form_id, $data );

	$cust_subject = get_post_meta( $form_id, '_gti_cust_subject', true );
	if ( ! $cust_subject ) $cust_subject = __( 'お問い合わせありがとうございます', 'gti-forms' );

	$cust_body_tmpl = get_post_meta( $form_id, '_gti_cust_body', true );
	if ( ! $cust_body_tmpl ) {
		$cust_body_tmpl = sprintf( __( "%s 様\n\nお問い合わせありがとうございました。\n以下の内容で受け付けました。\n\n{all_fields}\n\n担当者より折り返しご連絡いたします。", 'gti-forms' ), '{name}' );
	}

	// Get global sender settings
	$from_name = get_option( 'gti_forms_from_name', $site_name );
	$from_email = get_option( 'gti_forms_from_email', get_option( 'admin_email' ) );

	// 1. Admin Notification (Notice only)
	$admin_headers = array('Content-Type: text/plain; charset=UTF-8');
	$admin_headers[] = 'From: ' . $from_name . ' <' . $from_email . '>';

	// CC and BCC
	$admin_cc = get_post_meta( $form_id, '_gti_admin_cc', true );
	$admin_bcc = get_post_meta( $form_id, '_gti_admin_bcc', true );

	/**
	 * Filters for CC and BCC
	 */
	$admin_cc = apply_filters( 'gti_forms_admin_cc', $admin_cc, $form_id, $data );
	$admin_bcc = apply_filters( 'gti_forms_admin_bcc', $admin_bcc, $form_id, $data );

	if ( $admin_cc ) $admin_headers[] = 'Cc: ' . $admin_cc;
	if ( $admin_bcc ) $admin_headers[] = 'Bcc: ' . $admin_bcc;

	$admin_subject = sprintf( __( '【通知】%sにお問い合わせがありました', 'gti-forms' ), $form_title );
	$admin_body = sprintf( __( '%s の「%s」から新しいお問い合わせがありました。', 'gti-forms' ), $site_name, $form_title ) . "\n\n";

	$admin_email_type = get_post_meta( $form_id, '_gti_admin_email_type', true );
	if ( $admin_email_type === 'full' ) {
		$admin_body .= __( '【内容】', 'gti-forms' ) . "\n";
		foreach ( $data as $label => $value ) {
			$admin_body .= "{$label}: {$value}\n";
		}
	$admin_body .= "\n";
	}

	$admin_body .= __( '管理画面にログインして内容を確認してください。', 'gti-forms' ) . "\n";
	$admin_body .= admin_url( 'edit.php?post_type=gti-inquiry' ) . "\n";

	$should_send_admin = get_post_meta( $form_id, '_gti_send_admin_email', true );
	if ( $should_send_admin === '' ) $should_send_admin = '1';

	if ( $should_send_admin === '1' ) {
		wp_mail( $admin_recipient, $admin_subject, $admin_body, $admin_headers );
	}

	// 2. Customer Confirmation (Tag replacement)
	$cust_headers = array('Content-Type: text/plain; charset=UTF-8');
	$cust_headers[] = 'From: ' . $from_name . ' <' . $from_email . '>';

	$should_send_cust = get_post_meta( $form_id, '_gti_send_cust_email', true );
	if ( $should_send_cust === '' ) $should_send_cust = '1'; // Default on

	if ( $should_send_cust === '1' && $customer_email && $cust_body_tmpl ) {
		$all_fields_text = "--------------------------------------------------\n";
		foreach ( $data as $label => $value ) {
			$all_fields_text .= "【{$label}】\n{$value}\n\n";
		}
		$all_fields_text .= "--------------------------------------------------";

		// Tag replacement
		$find = array('{all_fields}', '{name}', '{email}');
		$replace = array(
			$all_fields_text,
			isset($raw_data['your-name']) ? $raw_data['your-name'] : '',
			isset($raw_data['your-email']) ? $raw_data['your-email'] : $customer_email
		);

		// Also support custom name attributes if they exist in raw_data
		foreach($raw_data as $key => $val) {
			$find[] = '{' . $key . '}';
			$replace[] = $val;
		}

		// ALSO support Labels from filtered $data as tags
		foreach($data as $label => $val) {
			$find[] = '{' . $label . '}';
			$replace[] = is_array($val) ? implode(', ', $val) : $val;
		}

		$cust_body = str_replace( $find, $replace, $cust_body_tmpl );
		
		wp_mail( $customer_email, $cust_subject, $cust_body, $cust_headers );
	}
}
