<?php
/**
 * Register Blocks for Form Builder
 */

function gti_forms_register_blocks() {
	// Register block assets
	wp_register_script(
		'gti-forms-blocks-js',
		GTI_FORMS_URL . 'assets/blocks.js',
		array( 'wp-blocks', 'wp-element', 'wp-editor', 'wp-components' )
	);

	wp_register_style(
		'gti-forms-blocks-css',
		GTI_FORMS_URL . 'assets/blocks.css'
	);

	// Register blocks (Server side part if needed, but we'll use front-end parsing mostly)
	register_block_type( 'gti/form', array(
		'editor_script' => 'gti-forms-blocks-js',
		'editor_style'  => 'gti-forms-blocks-css',
	) );
}
add_action( 'init', 'gti_forms_register_blocks' );

/**
 * Filter allowed blocks in gti-form post type
 */
function gti_forms_allowed_block_types( $allowed_blocks, $editor_context ) {
	if ( $editor_context->post->post_type === 'gti-form' ) {
		return array(
			'gti/form-text',
			'gti/form-email',
			'gti/form-textarea',
			'gti/form-select',
			'gti/form-hidden',
			'gti/form-submit',
			'gti/form-stripe',
			'core/paragraph',
			'core/heading',
		);
	}
	return $allowed_blocks;
}
add_filter( 'allowed_block_types_all', 'gti_forms_allowed_block_types', 10, 2 );

/**
 * Enqueue block assets for front-end (if any specific)
 */
function gti_forms_enqueue_assets() {
	wp_enqueue_style( 'gti-forms-frontend', GTI_FORMS_URL . 'assets/frontend.css' );
}
add_action( 'wp_enqueue_scripts', 'gti_forms_enqueue_assets' );
