<?php
/**
 * Analytics and Chart Logic
 */

function gti_forms_analytics_menu() {
	add_submenu_page(
		'edit.php?post_type=gti-form',
		__( '分析 (Analytics)', 'gti-forms' ),
		__( '分析', 'gti-forms' ),
		'manage_options',
		'gti-forms-analytics',
		'gti_forms_render_analytics_page'
	);
}
add_action( 'admin_menu', 'gti_forms_analytics_menu' );

function gti_forms_render_analytics_page() {
	// Calculate stats for the last 30 days
	$days = 30;
	$stats = array();
	for ( $i = $days - 1; $i >= 0; $i-- ) {
		$date = date( 'Y-m-d', strtotime( "-$i days" ) );
		$stats[$date] = 0;
	}

	$args = array(
		'post_type'      => 'gti-inquiry',
		'posts_per_page' => -1,
		'date_query'     => array(
			array(
				'after' => "$days days ago",
			),
		),
	);
	$query = new WP_Query( $args );

	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) {
			$query->the_post();
			$date = get_the_date( 'Y-m-d' );
			if ( isset( $stats[$date] ) ) {
				$stats[$date]++;
			}
		}
	}
	wp_reset_postdata();

	$labels = array_keys( $stats );
	$data = array_values( $stats );
	$total_inquiries = array_sum( $data );

	?>
	<div class="wrap gti-analytics-wrap">
		<h1><?php _e( 'GTI Forms 分析', 'gti-forms' ); ?></h1>
		
		<div class="gti-stats-overview" style="display: flex; gap: 20px; margin-top: 20px;">
			<div class="card" style="flex: 1; padding: 20px; text-align: center;">
				<h2 style="margin:0; font-size: 14px; color: #666;"><?php printf( __( '過去%d日間の総件数', 'gti-forms' ), $days ); ?></h2>
				<p style="font-size: 42px; font-weight: bold; margin: 10px 0; color: #2271b1;"><?php echo $total_inquiries; ?> <small style="font-size: 16px; color: #666;">件</small></p>
			</div>
			<div class="card" style="flex: 2; padding: 20px;">
				<h2 style="margin:0; font-size: 14px; color: #666;"><?php _e( '日別の受信件数推移', 'gti-forms' ); ?></h2>
				<div style="height: 300px; margin-top: 20px;">
					<canvas id="gtiInquiryChart"></canvas>
				</div>
			</div>
		</div>

		<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
		<script>
		document.addEventListener('DOMContentLoaded', function() {
			var ctx = document.getElementById('gtiInquiryChart').getContext('2d');
			var chart = new Chart(ctx, {
				type: 'line',
				data: {
					labels: <?php echo json_encode( $labels ); ?>,
					datasets: [{
						label: '<?php _e( '受信件数', 'gti-forms' ); ?>',
						data: <?php echo json_encode( $data ); ?>,
						borderColor: '#2271b1',
						backgroundColor: 'rgba(34, 113, 177, 0.1)',
						borderWidth: 3,
						pointRadius: 4,
						pointBackgroundColor: '#fff',
						fill: true,
						tension: 0.3
					}]
				},
				options: {
					responsive: true,
					maintainAspectRatio: false,
					plugins: {
						legend: { display: false }
					},
					scales: {
						y: {
							beginAtZero: true,
							ticks: {
								stepSize: 1,
								precision: 0
							}
						},
						x: {
							ticks: {
								maxRotation: 45,
								minRotation: 45
							}
						}
					}
				}
			});
		});
		</script>
	</div>
	<?php
}
