<?php
/**
 * Register Custom Post Types
 */

function gti_forms_register_post_types() {
	// Form Definition Post Type
	register_post_type( 'gti-form', array(
		'labels' => array(
			'name'          => 'GTI Forms',
			'singular_name' => __( 'Form', 'gti-forms' ),
			'menu_name'     => 'GTI Forms',
			'all_items'     => __( 'フォーム一覧', 'gti-forms' ),
			'add_new'       => __( '新規追加', 'gti-forms' ),
			'add_new_item'  => __( '新規メールフォーム追加', 'gti-forms' ),
			'edit_item'     => __( 'フォーム編集', 'gti-forms' ),
		),
		'public'        => false,
		'show_ui'       => true,
		'supports'      => array( 'title', 'editor' ),
		'show_in_rest'  => true, // Enable Block Editor
		'menu_icon'     => 'dashicons-feedback',
		'menu_position' => 25, // Above standard locations
		'template'      => array(
			array( 'gti/form-text', array( 'label' => __( 'お名前', 'gti-forms' ), 'name' => 'your-name', 'required' => true ) ),
			array( 'gti/form-email', array( 'label' => __( 'メールアドレス', 'gti-forms' ), 'name' => 'your-email', 'required' => true ) ),
			array( 'gti/form-text', array( 'label' => __( '件名', 'gti-forms' ), 'name' => 'subject' ) ),
			array( 'gti/form-textarea', array( 'label' => __( 'メッセージ内容', 'gti-forms' ), 'name' => 'message' ) ),
			array( 'gti/form-submit', array( 'text' => __( '送信する', 'gti-forms' ) ) ),
		),
	) );

	// Inquiry Submission Post Type
	$inquiry_label = get_option('gti_forms_inquiry_label', '受信メール');
	register_post_type( 'gti-inquiry', array(
		'labels' => array(
			'name'          => $inquiry_label,
			'singular_name' => __( '受信データ', 'gti-forms' ),
		),
		'public'        => false,
		'show_ui'       => true,
		'show_in_menu'  => false, // We added this as a submenu manually in admin.php
		'supports'      => array( 'title' ), // Remove custom-fields to keep it clean
		'show_in_rest'  => false,
	) );
}
add_action( 'init', 'gti_forms_register_post_types' );
