<?php
/*
Plugin Name: GTI Forms
Description: A rich inquiry form plugin using Block Editor.
Version: 1.1.0
Author: ウェブ屋のさとーさん@GTI Inc.
Text Domain: gti-forms
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'GTI_FORMS_PATH', plugin_dir_path( __FILE__ ) );
define( 'GTI_FORMS_URL', plugin_dir_url( __FILE__ ) );

// Load components
require_once GTI_FORMS_PATH . 'vendor/autoload.php';

// Enable automatic updates from GitHub
$myUpdateChecker = \YahnisElsts\PluginUpdateChecker\V5\PucFactory::buildUpdateChecker(
	'https://github.com/taman777/gti-forms/',
	__FILE__,
	'gti-forms'
);

require_once GTI_FORMS_PATH . 'includes/post-types.php';
require_once GTI_FORMS_PATH . 'includes/blocks.php';
require_once GTI_FORMS_PATH . 'includes/shortcodes.php';
require_once GTI_FORMS_PATH . 'includes/submission.php';
require_once GTI_FORMS_PATH . 'includes/admin.php';
require_once GTI_FORMS_PATH . 'includes/emails.php';
require_once GTI_FORMS_PATH . 'includes/analytics.php';

// Internationalization
function gti_forms_load_textdomain() {
	load_plugin_textdomain( 'gti-forms', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
add_action( 'init', 'gti_forms_load_textdomain' );

// Activation hook
register_activation_hook( __FILE__, 'gti_forms_activate' );
function gti_forms_activate() {
	gti_forms_register_post_types();
	flush_rewrite_rules();
}

/**
 * Enqueue scripts and styles
 */
function gti_forms_head_scripts() {
	?>
	<script src="https://js.stripe.com/v3/"></script>
	<script>
		var gtiForms = {
			ajaxUrl: '<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>',
			stripePubKey: '<?php echo esc_js( get_option('gti_forms_stripe_pub_key') ); ?>',
			i18n: {
				back: '<?php echo esc_js( __( '戻る', 'gti-forms' ) ); ?>',
				submit: '<?php echo esc_js( __( '送信する', 'gti-forms' ) ); ?>',
				error: '<?php echo esc_js( __( 'エラーが発生しました。', 'gti-forms' ) ); ?>'
			}
		};
	</script>
	<?php
}
add_action( 'wp_head', 'gti_forms_head_scripts' );
