(function (blocks, element, editor, components) {
    var el = element.createElement;
    var RichText = editor.RichText;
    var InspectorControls = editor.InspectorControls;
    var TextControl = components.TextControl;
    var ToggleControl = components.ToggleControl;

    var commonAttributes = {
        label: { type: 'string', default: 'ラベル' },
        name: { type: 'string', default: '' },
        placeholder: { type: 'string', default: '' },
        required: { type: 'boolean', default: false },
    };

    // Text Input Block
    blocks.registerBlockType('gti/form-text', {
        title: 'GTI: テキスト入力',
        icon: 'forms',
        category: 'common',
        attributes: commonAttributes,
        edit: function (props) {
            var attr = props.attributes;
            function updateLabel(val) { props.setAttributes({ label: val }); }
            function updateName(val) { props.setAttributes({ name: val }); }
            function updatePlaceholder(val) { props.setAttributes({ placeholder: val }); }
            function updateRequired(val) { props.setAttributes({ required: val }); }

            return [
                el(InspectorControls, {},
                    el(components.PanelBody, { title: '基本設定' },
                        el(TextControl, { label: 'name属性', value: attr.name, onChange: updateName }),
                        el(TextControl, { label: 'プレースホルダー', value: attr.placeholder, onChange: updatePlaceholder }),
                        el(ToggleControl, { label: '必須', checked: attr.required, onChange: updateRequired })
                    )
                ),
                el('div', { className: 'gti-block-input-editor' },
                    el(RichText, { tagName: 'label', value: attr.label, onChange: updateLabel }),
                    el('input', { type: 'text', placeholder: attr.placeholder, disabled: true })
                )
            ];
        },
        save: function () { return null; } // Rendered on PHP
    });

    // Email Input Block
    blocks.registerBlockType('gti/form-email', {
        title: 'GTI: メールアドレス',
        icon: 'email',
        category: 'common',
        attributes: commonAttributes,
        edit: function (props) {
            var attr = props.attributes;
            return [
                el(InspectorControls, {},
                    el(components.PanelBody, { title: '基本設定' },
                        el(TextControl, { label: 'name属性', value: attr.name, onChange: function (v) { props.setAttributes({ name: v }) } }),
                        el(ToggleControl, { label: '必須', checked: attr.required, onChange: function (v) { props.setAttributes({ required: v }) } })
                    )
                ),
                el('div', { className: 'gti-block-input-editor' },
                    el(RichText, { tagName: 'label', value: attr.label, onChange: function (v) { props.setAttributes({ label: v }) } }),
                    el('input', { type: 'email', placeholder: 'example@example.com', disabled: true })
                )
            ];
        },
        save: function () { return null; }
    });

    // Textarea Block
    blocks.registerBlockType('gti/form-textarea', {
        title: 'GTI: 複数行テキスト',
        icon: 'editor-paragraph',
        category: 'common',
        attributes: commonAttributes,
        edit: function (props) {
            var attr = props.attributes;
            return el('div', { className: 'gti-block-input-editor' },
                el(RichText, { tagName: 'label', value: attr.label, onChange: function (v) { props.setAttributes({ label: v }) } }),
                el('textarea', { disabled: true })
            );
        },
        save: function () { return null; }
    });

    // Hidden Input Block
    blocks.registerBlockType('gti/form-hidden', {
        title: 'GTI: 隠しフィールド',
        icon: 'hidden',
        category: 'common',
        attributes: {
            name: { type: 'string', default: '' },
            value: { type: 'string', default: '' },
            label: { type: 'string', default: '隠しフィールド' }, // Internal label for admin
        },
        edit: function (props) {
            var attr = props.attributes;
            return [
                el(InspectorControls, {},
                    el(components.PanelBody, { title: '基本設定' },
                        el(TextControl, { label: 'name属性', value: attr.name, onChange: function (v) { props.setAttributes({ name: v }) } }),
                        el(TextControl, { label: '初期値', value: attr.value, onChange: function (v) { props.setAttributes({ value: v }) } }),
                        el(TextControl, { label: '管理用ラベル', value: attr.label, onChange: function (v) { props.setAttributes({ label: v }) } })
                    )
                ),
                el('div', { className: 'gti-block-hidden-editor', style: { background: '#f0f0f0', padding: '10px', border: '1px dashed #ccc', opacity: 0.6 } },
                    el('strong', {}, 'Hidden: '),
                    el('span', {}, attr.label + ' (' + attr.name + ') = ' + attr.value)
                )
            ];
        },
        save: function () { return null; }
    });

    // Submit Button Block
    blocks.registerBlockType('gti/form-submit', {
        title: 'GTI: 送信ボタン',
        icon: 'paper-plane',
        category: 'common',
        attributes: {
            text: { type: 'string', default: '送信する' }
        },
        edit: function (props) {
            return [
                el(InspectorControls, {},
                    el(components.PanelBody, { title: 'ボタン設定' },
                        el(TextControl, {
                            label: 'ボタンのラベル',
                            value: props.attributes.text,
                            onChange: function (v) { props.setAttributes({ text: v }) }
                        })
                    )
                ),
                el('div', { className: 'gti-block-submit-editor' },
                    el(RichText, { tagName: 'button', value: props.attributes.text, onChange: function (v) { props.setAttributes({ text: v }) } })
                )
            ];
        },
        save: function () { return null; }
    });

    // Stripe Block
    blocks.registerBlockType('gti/form-stripe', {
        title: 'GTI: Stripe決済',
        icon: 'cart',
        category: 'common',
        attributes: {
            amount: { type: 'number', default: 1000 },
            label: { type: 'string', default: '支払い' },
        },
        edit: function (props) {
            var attr = props.attributes;
            return [
                el(InspectorControls, {},
                    el(components.PanelBody, { title: '決済設定' },
                        el(components.TextControl, {
                            label: '金額 (円)',
                            type: 'number',
                            value: attr.amount,
                            onChange: function (v) { props.setAttributes({ amount: parseInt(v) }) }
                        }),
                    )
                ),
                el('div', { className: 'gti-block-stripe-editor' },
                    el(RichText, {
                        tagName: 'button',
                        value: attr.label,
                        onChange: function (v) { props.setAttributes({ label: v }) }
                    }),
                    el('p', { className: 'stripe-hint' }, '金額: ' + attr.amount + '円')
                )
            ];
        },
        save: function () { return null; }
    });

})(
    window.wp.blocks,
    window.wp.element,
    window.wp.blockEditor || window.wp.editor,
    window.wp.components
);
