# <img src="./assets/icon.png" width="40" height="40" style="vertical-align:middle; margin-right:10px;"> GTI Forms

GTI Forms は、WordPress のブロックエディタを活用してフォームを作成し、**受信した問い合わせをメールに頼らず WordPress 管理画面内で完結して管理すること**を目的としたプラグインです。

## 特徴

- **管理画面での一元管理**: 全ての問い合わせをデータベースに保存し、既読・未読、対応ステータスを管理画面で一括管理できます。
- **ダッシュボード連携**: WordPress ダッシュボードに専用ウィジェットを追加。最新の未読お問い合わせ 5 件をトップ画面で即座に確認できます。
- **直感的なフォーム作成**: ブロック形式でマウス操作のみでフォームを構築できます。
- **リッチな管理画面**: 受信した問い合わせを既読・未読管理し、対応メモを残せます。サイドバーには常に「未読数」がバッジで表示されます。
- **通知メールのセキュリティ**: 管理者への通知メールに「全ての入力内容を含める」か「管理画面へのリンクのみ送る」かを選択可能。機密性の高い情報の漏洩リスクを低減できます。
- **Stripe 連携**: 決済ブロックを使用して、フォーム内での支払い（Stripe）に対応しています。
- **自動返信・通知メール**: 柔軟な置換タグ（`{name}`, `{all_fields}` など）を使用した通知設定。送信元名やアドレスもグローバルに設定可能です。
- **強力なスパム・セキュリティ対策**: 全ての保存・送信処理に Nonce チェックを実装。さらにバリデーションフックにより「Throws SPAM Away」等の外部プラグインと連携可能です。
- **高度なカスタマイズ性**: 豊富な Action/Filter フックを提供。フォーム送信データの加工、動的リダイレクト、決済額の計算、保存タイトルの変更などが可能です。
- **動的メールルーティング**: 入力された内容（例：「店舗名」「担当部署」）に応じて、通知メールの宛先（To, CC, BCC）をプログラムで自由に変更できます。複数店舗展開のサイト等に最適です。
- **完了画面のカスタマイズ**: フォームごとに送信完了後のメッセージを管理画面から自由に設定できます。
- **GitHub 自動更新**: GitHub でリリースを作成すると、WordPress 管理画面から直接アップデートが可能です。

## インストール方法

1. このリポジトリを ZIP 形式でダウンロードします。
2. WordPress 管理画面の「プラグイン」>「新規追加」>「プラグインのアップロード」から ZIP を選択してインストールします。
3. プラグインを有効化します。

## 開発者向け

このプラグインは Composer を使用して依存関係を管理しています。

```bash
composer install
```

### フックと拡張
開発者向けの Action/Filter Hook の一覧とサンプルコードは、[HOOKS.md](./HOOKS.md) を参照してください。

### 自動更新の仕組み

`yahnis-elsts/plugin-update-checker` を使用しています。`gti-forms.php` の `Version` ヘッダーを更新し、GitHub で同じバージョンのタグ（例: `v1.0.1`）を持つリリースを作成することで、ユーザーに更新が通知されます。

## ライセンス

[GTI](https://gti.co.jp)
