<ul>
<?php
/* ---------- 初期設定 ----------- */
// livedoorブログのアカウント
$livedoor_account = "taman777";

// 取得したいRSSのurl
$blog_rss_url = "http://blog.livedoor.jp/$livedoor_account/index.rdf";

// 取得表示したい件数
$post_count = 5;

// 記事タイトル文字数（バイト数ではありません）
$title_length = 20;

// 記事表示文字数（バイト数ではありません）
$description_length = 20;

// キャッシュを使用するかどうか
$cache_flg = true; // trueは使用する falseは使用しない（常にHTTPリクエスト発行する）
// キャッシュを使用する（HTTPリクエストを行わない）秒数
$cache_sec = 3600; // 3600秒 ＝ 30分
// キャシュを保存するディレクトリ
// 指定するディレクトリは パーミッションを　707 か 777 に設定してください
$cache_dir = "./cache";


// magpierss のモジュールを読込み
require_once("./magpierss/rss_fetch.inc");

// キャッシュ期間を指定する この指定数値（単位は秒）だけキャッシュを利用
// その間はHTTPリクエストを行いません。
define("MAGPIE_CACHE_ON", $cache_flg);
define("MAGPIE_CACHE_AGE", $cache_sec);

// キャッシュを保存するディレクトリを指定
define("MAGPIE_CACHE_DIR", $cache_dir);

// エンコードを UTF-8 に指定
define("MAGPIE_OUTPUT_ENCODING", "UTF-8");

// RSSを取得する
$rss = fetch_rss($blog_rss_url);

$cnt = 0;
foreach ($rss->items as $item) {
    // リンクアドレス
    $url = mb_convert_encoding($item['link'],"UTF-8","auto");
    // タイトル
    $title = mb_substr(mb_convert_encoding($item['title'],"UTF-8","auto"), 0, $title_length);
    // 記事内容
    $description = mb_substr(strip_tags(mb_convert_encoding($item['description'],"UTF-8","auto")), 0, $description_length);
    // 日付
    $date = date("Y/m/d", strtotime($item['dc']['date']));
    // PR除く
    if (preg_match("/^PR:.+$/", $title) != 0) continue;
/* ----- この下のHTMLを変更するとフォーマットを変更できます ----- */
echo <<< END
<li><a href="$url" target="_blank">$date $title</a> $description</li>
END;
/* ----- この上のHTMLを変更するとフォーマットを変更できます ----- */
    // 設定件数取得したら終了
    if ($cnt == $post_count - 1) {
        break;
    }
    $cnt ++;
}
?>
</ul>